import type { Facet } from '@atproto/api';
import { MfmNode } from '../services/index.js';
import { KNOWN_SOFTWARE } from '../data/driver.js';
export type AppTextNodeType = 'para' | 'text' | 'mention' | 'tag' | 'customEmoji' | 'link' | 'inline' | 'italic' | 'bold' | 'code';
export type NodeContentBase = {
    uuid: string;
    nodes: NodeContent[];
};
export declare const WrapperNodes: AppTextNodeType[];
export type NodeContentExtended = {
    type: 'para';
} | {
    type: 'text';
    text: string;
} | {
    type: 'mention';
    text: string | null;
    url: string | null;
} | {
    type: 'tag';
    text: string;
} | {
    type: 'link';
    text: string;
    url: string;
} | {
    type: 'inline';
} | {
    type: 'bold';
} | {
    type: 'italic';
} | {
    type: 'code';
    text: string;
} | {
    type: 'customEmoji';
    text: string;
    value: string;
};
export type NodeContent = NodeContentBase & NodeContentExtended;
export type AppParsedTextNodes = NodeContent[];
export declare class Builder {
    protected readonly input: string;
    parsed: AppParsedTextNodes;
    links: Map<string, string>;
    mentions: {
        url?: string;
        text?: string;
    }[];
    nodes: MfmNode[][];
    constructor({ input }: {
        input: string;
    });
    solve(): this;
    process(): void;
    private parser;
    decodeUrlString(input: string): string;
}
declare class Parser {
    static parse(driver: KNOWN_SOFTWARE | string, input: string, facets?: Facet[]): AppParsedTextNodes;
    private static toUtf8;
    private static toUtf16;
    private static withMfm;
    private static withFacets;
}
export { Parser as TextNodeParser };
//# sourceMappingURL=text-nodes.d.ts.map