import { z } from 'zod';
import { KNOWN_SOFTWARE } from '../data/driver.js';
declare const appNotificationGroupedUserItemSchema: z.ZodObject<{
    item: z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodNullable<z.ZodString>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
        banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        meta: z.ZodObject<{
            isProfileLocked: z.ZodBoolean;
            isBot: z.ZodBoolean;
            fields: z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                value: z.ZodOptional<z.ZodString>;
                verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                cid: z.ZodOptional<z.ZodString>;
                cts: z.ZodOptional<z.ZodString>;
                src: z.ZodOptional<z.ZodString>;
                uri: z.ZodOptional<z.ZodString>;
                val: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        description: z.ZodString;
        parsedDescription: z.ZodArray<z.ZodAny>;
        stats: z.ZodObject<{
            posts: z.ZodNullable<z.ZodNumber>;
            followers: z.ZodNullable<z.ZodNumber>;
            following: z.ZodNullable<z.ZodNumber>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
        }, z.core.$strip>;
        relationship: z.ZodObject<{
            blocking: z.ZodNullable<z.ZodBoolean>;
            blockedBy: z.ZodNullable<z.ZodBoolean>;
            domainBlocking: z.ZodNullable<z.ZodBoolean>;
            followedBy: z.ZodNullable<z.ZodBoolean>;
            following: z.ZodNullable<z.ZodBoolean>;
            muting: z.ZodNullable<z.ZodBoolean>;
            mutingNotifications: z.ZodNullable<z.ZodBoolean>;
            note: z.ZodNullable<z.ZodString>;
            requested: z.ZodNullable<z.ZodBoolean>;
            requestedBy: z.ZodNullable<z.ZodBoolean>;
            showingReblogs: z.ZodNullable<z.ZodBoolean>;
        }, z.core.$strip>;
    }, z.core.$strip>;
    types: z.ZodArray<z.ZodString>;
    extraData: z.ZodAny;
}, z.core.$strip>;
type NotificationUserGroupType = z.infer<typeof appNotificationGroupedUserItemSchema>;
export declare const appNotificationObjectSchema: z.ZodObject<{
    id: z.ZodString;
    type: z.ZodString;
    createdAt: z.ZodCoercedDate<unknown>;
    user: z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodNullable<z.ZodString>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
        banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        meta: z.ZodObject<{
            isProfileLocked: z.ZodBoolean;
            isBot: z.ZodBoolean;
            fields: z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                value: z.ZodOptional<z.ZodString>;
                verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                cid: z.ZodOptional<z.ZodString>;
                cts: z.ZodOptional<z.ZodString>;
                src: z.ZodOptional<z.ZodString>;
                uri: z.ZodOptional<z.ZodString>;
                val: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        description: z.ZodString;
        parsedDescription: z.ZodArray<z.ZodAny>;
        stats: z.ZodObject<{
            posts: z.ZodNullable<z.ZodNumber>;
            followers: z.ZodNullable<z.ZodNumber>;
            following: z.ZodNullable<z.ZodNumber>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
        }, z.core.$strip>;
        relationship: z.ZodObject<{
            blocking: z.ZodNullable<z.ZodBoolean>;
            blockedBy: z.ZodNullable<z.ZodBoolean>;
            domainBlocking: z.ZodNullable<z.ZodBoolean>;
            followedBy: z.ZodNullable<z.ZodBoolean>;
            following: z.ZodNullable<z.ZodBoolean>;
            muting: z.ZodNullable<z.ZodBoolean>;
            mutingNotifications: z.ZodNullable<z.ZodBoolean>;
            note: z.ZodNullable<z.ZodString>;
            requested: z.ZodNullable<z.ZodBoolean>;
            requestedBy: z.ZodNullable<z.ZodBoolean>;
            showingReblogs: z.ZodNullable<z.ZodBoolean>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    post: z.ZodNullable<z.ZodObject<{
        uuid: z.ZodString;
        id: z.ZodString;
        visibility: z.ZodString;
        createdAt: z.ZodString;
        postedBy: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
        }, z.core.$strip>;
        content: z.ZodObject<{
            raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            parsed: z.ZodArray<z.ZodAny>;
            media: z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                alt: z.ZodNullable<z.ZodString>;
                type: z.ZodString;
                blurhash: z.ZodNullable<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        interaction: z.ZodObject<{
            boosted: z.ZodBoolean;
            liked: z.ZodBoolean;
            bookmarked: z.ZodBoolean;
        }, z.core.$strip>;
        stats: z.ZodObject<{
            replyCount: z.ZodNumber;
            boostCount: z.ZodNumber;
            likeCount: z.ZodNumber;
            reactions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                count: z.ZodNumber;
                me: z.ZodBoolean;
                accounts: z.ZodArray<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            mediaContainerHeight: z.ZodNumber;
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
            translationOutput: z.ZodOptional<z.ZodString>;
            translationType: z.ZodOptional<z.ZodString>;
            reactionEmojis: z.ZodArray<z.ZodObject<{
                height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                name: z.ZodString;
                url: z.ZodString;
            }, z.core.$strip>>;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                text: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        meta: z.ZodObject<{
            sensitive: z.ZodBoolean;
            cw: z.ZodNullable<z.ZodString>;
            isBoost: z.ZodBoolean;
            isReply: z.ZodBoolean;
            mentions: z.ZodArray<z.ZodObject<{
                id: z.ZodString;
                handle: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            }, z.core.$strip>>;
            cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        state: z.ZodObject<{
            isBookmarkStateFinal: z.ZodBoolean;
        }, z.core.$strip>;
        atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            viewer: z.ZodOptional<z.ZodObject<{
                like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                pinned: z.ZodOptional<z.ZodAny>;
                repost: z.ZodOptional<z.ZodAny>;
                replyDisabled: z.ZodOptional<z.ZodBoolean>;
                threadMuted: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>>;
        replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
            replyTo: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            boostedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
            quotedFrom: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                uuid: z.ZodString;
                id: z.ZodString;
                visibility: z.ZodString;
                createdAt: z.ZodString;
                postedBy: z.ZodObject<{
                    id: z.ZodString;
                    avatarUrl: z.ZodString;
                    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsedDisplayName: z.ZodArray<z.ZodAny>;
                    handle: z.ZodString;
                    instance: z.ZodString;
                }, z.core.$strip>;
                content: z.ZodObject<{
                    raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    parsed: z.ZodArray<z.ZodAny>;
                    media: z.ZodArray<z.ZodObject<{
                        url: z.ZodString;
                        previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                        alt: z.ZodNullable<z.ZodString>;
                        type: z.ZodString;
                        blurhash: z.ZodNullable<z.ZodString>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                interaction: z.ZodObject<{
                    boosted: z.ZodBoolean;
                    liked: z.ZodBoolean;
                    bookmarked: z.ZodBoolean;
                }, z.core.$strip>;
                stats: z.ZodObject<{
                    replyCount: z.ZodNumber;
                    boostCount: z.ZodNumber;
                    likeCount: z.ZodNumber;
                    reactions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        count: z.ZodNumber;
                        me: z.ZodBoolean;
                        accounts: z.ZodArray<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                calculated: z.ZodObject<{
                    mediaContainerHeight: z.ZodNumber;
                    emojis: z.ZodMap<z.ZodString, z.ZodString>;
                    translationOutput: z.ZodOptional<z.ZodString>;
                    translationType: z.ZodOptional<z.ZodString>;
                    reactionEmojis: z.ZodArray<z.ZodObject<{
                        height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                        name: z.ZodString;
                        url: z.ZodString;
                    }, z.core.$strip>>;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        text: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                }, z.core.$strip>;
                meta: z.ZodObject<{
                    sensitive: z.ZodBoolean;
                    cw: z.ZodNullable<z.ZodString>;
                    isBoost: z.ZodBoolean;
                    isReply: z.ZodBoolean;
                    mentions: z.ZodArray<z.ZodObject<{
                        id: z.ZodString;
                        handle: z.ZodOptional<z.ZodString>;
                        url: z.ZodOptional<z.ZodString>;
                        acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                        username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    }, z.core.$strip>>;
                    cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>;
                state: z.ZodObject<{
                    isBookmarkStateFinal: z.ZodBoolean;
                }, z.core.$strip>;
                atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                    viewer: z.ZodOptional<z.ZodObject<{
                        like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                        embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                        pinned: z.ZodOptional<z.ZodAny>;
                        repost: z.ZodOptional<z.ZodAny>;
                        replyDisabled: z.ZodOptional<z.ZodBoolean>;
                        threadMuted: z.ZodOptional<z.ZodBoolean>;
                    }, z.core.$strip>>;
                }, z.core.$strip>>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        rootPost: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            uuid: z.ZodString;
            id: z.ZodString;
            visibility: z.ZodString;
            createdAt: z.ZodString;
            postedBy: z.ZodObject<{
                id: z.ZodString;
                avatarUrl: z.ZodString;
                displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsedDisplayName: z.ZodArray<z.ZodAny>;
                handle: z.ZodString;
                instance: z.ZodString;
            }, z.core.$strip>;
            content: z.ZodObject<{
                raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                parsed: z.ZodArray<z.ZodAny>;
                media: z.ZodArray<z.ZodObject<{
                    url: z.ZodString;
                    previewUrl: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    width: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    height: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
                    alt: z.ZodNullable<z.ZodString>;
                    type: z.ZodString;
                    blurhash: z.ZodNullable<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            interaction: z.ZodObject<{
                boosted: z.ZodBoolean;
                liked: z.ZodBoolean;
                bookmarked: z.ZodBoolean;
            }, z.core.$strip>;
            stats: z.ZodObject<{
                replyCount: z.ZodNumber;
                boostCount: z.ZodNumber;
                likeCount: z.ZodNumber;
                reactions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    count: z.ZodNumber;
                    me: z.ZodBoolean;
                    accounts: z.ZodArray<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                mediaContainerHeight: z.ZodNumber;
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
                translationOutput: z.ZodOptional<z.ZodString>;
                translationType: z.ZodOptional<z.ZodString>;
                reactionEmojis: z.ZodArray<z.ZodObject<{
                    height: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    width: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
                    name: z.ZodString;
                    url: z.ZodString;
                }, z.core.$strip>>;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    text: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            meta: z.ZodObject<{
                sensitive: z.ZodBoolean;
                cw: z.ZodNullable<z.ZodString>;
                isBoost: z.ZodBoolean;
                isReply: z.ZodBoolean;
                mentions: z.ZodArray<z.ZodObject<{
                    id: z.ZodString;
                    handle: z.ZodOptional<z.ZodString>;
                    url: z.ZodOptional<z.ZodString>;
                    acct: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                    username: z.ZodNullable<z.ZodOptional<z.ZodString>>;
                }, z.core.$strip>>;
                cid: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                uri: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            }, z.core.$strip>;
            state: z.ZodObject<{
                isBookmarkStateFinal: z.ZodBoolean;
            }, z.core.$strip>;
            atProto: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                viewer: z.ZodOptional<z.ZodObject<{
                    like: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    embeddingDisabled: z.ZodOptional<z.ZodBoolean>;
                    pinned: z.ZodOptional<z.ZodAny>;
                    repost: z.ZodOptional<z.ZodAny>;
                    replyDisabled: z.ZodOptional<z.ZodBoolean>;
                    threadMuted: z.ZodOptional<z.ZodBoolean>;
                }, z.core.$strip>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>;
    extraData: z.ZodAny;
    read: z.ZodBoolean;
    users: z.ZodOptional<z.ZodArray<z.ZodObject<{
        item: z.ZodObject<{
            id: z.ZodString;
            avatarUrl: z.ZodString;
            displayName: z.ZodNullable<z.ZodString>;
            parsedDisplayName: z.ZodArray<z.ZodAny>;
            handle: z.ZodString;
            instance: z.ZodString;
            banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            meta: z.ZodObject<{
                isProfileLocked: z.ZodBoolean;
                isBot: z.ZodBoolean;
                fields: z.ZodArray<z.ZodObject<{
                    name: z.ZodOptional<z.ZodString>;
                    value: z.ZodOptional<z.ZodString>;
                    verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                    cid: z.ZodOptional<z.ZodString>;
                    cts: z.ZodOptional<z.ZodString>;
                    src: z.ZodOptional<z.ZodString>;
                    uri: z.ZodOptional<z.ZodString>;
                    val: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>;
            description: z.ZodString;
            parsedDescription: z.ZodArray<z.ZodAny>;
            stats: z.ZodObject<{
                posts: z.ZodNullable<z.ZodNumber>;
                followers: z.ZodNullable<z.ZodNumber>;
                following: z.ZodNullable<z.ZodNumber>;
            }, z.core.$strip>;
            calculated: z.ZodObject<{
                emojis: z.ZodMap<z.ZodString, z.ZodString>;
            }, z.core.$strip>;
            relationship: z.ZodObject<{
                blocking: z.ZodNullable<z.ZodBoolean>;
                blockedBy: z.ZodNullable<z.ZodBoolean>;
                domainBlocking: z.ZodNullable<z.ZodBoolean>;
                followedBy: z.ZodNullable<z.ZodBoolean>;
                following: z.ZodNullable<z.ZodBoolean>;
                muting: z.ZodNullable<z.ZodBoolean>;
                mutingNotifications: z.ZodNullable<z.ZodBoolean>;
                note: z.ZodNullable<z.ZodString>;
                requested: z.ZodNullable<z.ZodBoolean>;
                requestedBy: z.ZodNullable<z.ZodBoolean>;
                showingReblogs: z.ZodNullable<z.ZodBoolean>;
            }, z.core.$strip>;
        }, z.core.$strip>;
        types: z.ZodArray<z.ZodString>;
        extraData: z.ZodAny;
    }, z.core.$strip>>>;
}, z.core.$strip>;
type NotificationObjectType = z.infer<typeof appNotificationObjectSchema>;
declare class Parser {
    static rawToObject(input: any, driver: string | KNOWN_SOFTWARE, server: string): NotificationObjectType | null;
    static parse<T>(input: T | T[], driver: string | KNOWN_SOFTWARE, server: string): T extends unknown[] ? NotificationObjectType[] : NotificationObjectType;
}
export { Parser as NotificationParser };
export type { NotificationObjectType, NotificationUserGroupType };
//# sourceMappingURL=notification.d.ts.map