import { z } from 'zod';
import { KNOWN_SOFTWARE } from '../data/driver.js';
declare const feedObjectSchema: z.ZodObject<{
    uri: z.ZodString;
    cid: z.ZodString;
    did: z.ZodString;
    creator: z.ZodObject<{
        id: z.ZodString;
        avatarUrl: z.ZodString;
        displayName: z.ZodNullable<z.ZodString>;
        parsedDisplayName: z.ZodArray<z.ZodAny>;
        handle: z.ZodString;
        instance: z.ZodString;
        banner: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        meta: z.ZodObject<{
            isProfileLocked: z.ZodBoolean;
            isBot: z.ZodBoolean;
            fields: z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                value: z.ZodOptional<z.ZodString>;
                verifiedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
                cid: z.ZodOptional<z.ZodString>;
                cts: z.ZodOptional<z.ZodString>;
                src: z.ZodOptional<z.ZodString>;
                uri: z.ZodOptional<z.ZodString>;
                val: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>;
        description: z.ZodString;
        parsedDescription: z.ZodArray<z.ZodAny>;
        stats: z.ZodObject<{
            posts: z.ZodNullable<z.ZodNumber>;
            followers: z.ZodNullable<z.ZodNumber>;
            following: z.ZodNullable<z.ZodNumber>;
        }, z.core.$strip>;
        calculated: z.ZodObject<{
            emojis: z.ZodMap<z.ZodString, z.ZodString>;
        }, z.core.$strip>;
        relationship: z.ZodObject<{
            blocking: z.ZodNullable<z.ZodBoolean>;
            blockedBy: z.ZodNullable<z.ZodBoolean>;
            domainBlocking: z.ZodNullable<z.ZodBoolean>;
            followedBy: z.ZodNullable<z.ZodBoolean>;
            following: z.ZodNullable<z.ZodBoolean>;
            muting: z.ZodNullable<z.ZodBoolean>;
            mutingNotifications: z.ZodNullable<z.ZodBoolean>;
            note: z.ZodNullable<z.ZodString>;
            requested: z.ZodNullable<z.ZodBoolean>;
            requestedBy: z.ZodNullable<z.ZodBoolean>;
            showingReblogs: z.ZodNullable<z.ZodBoolean>;
        }, z.core.$strip>;
    }, z.core.$strip>;
    displayName: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    avatar: z.ZodOptional<z.ZodString>;
    likeCount: z.ZodOptional<z.ZodNumber>;
    labels: z.ZodOptional<z.ZodArray<z.ZodAny>>;
    viewer: z.ZodObject<{
        like: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
    indexedAt: z.ZodDate;
}, z.core.$strip>;
type FeedObjectType = z.infer<typeof feedObjectSchema>;
declare class Parser {
    static rawToObject(input: any, driver: KNOWN_SOFTWARE | string, server: string): FeedObjectType | null;
    static parse<T>(input: T | T[], driver: string | KNOWN_SOFTWARE, server: string): T extends unknown[] ? FeedObjectType[] : FeedObjectType;
}
export { Parser as FeedParser };
export type { FeedObjectType };
//# sourceMappingURL=feed.d.ts.map