import { z } from 'zod';
import { KNOWN_SOFTWARE } from '../data/driver.js';
declare const appMessageObjectSchema: z.ZodObject<{
    uuid: z.ZodString;
    id: z.ZodString;
    sender: z.ZodObject<{
        id: z.ZodString;
    }, z.core.$strip>;
    content: z.ZodObject<{
        raw: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
    createdAt: z.ZodString;
}, z.core.$strip>;
type MessageObjectType = z.infer<typeof appMessageObjectSchema>;
declare class Parser {
    private static export;
    static parse<T>(input: T | T[], driver: KNOWN_SOFTWARE, server: string): T extends unknown[] ? MessageObjectType[] : MessageObjectType;
    private static rawToJson;
}
export { Parser as ChatParser };
export type { MessageObjectType };
//# sourceMappingURL=chat.d.ts.map