import { PostTargetInterface } from './_interface.js';
import PostAdapterBase from './default.js';
import { Note } from 'misskey-js/autogen/models.js';
declare class MisskeyApiPostAdapter extends PostAdapterBase implements PostTargetInterface {
    ref: Note;
    constructor(ref: Note);
    getMentions: () => {
        id: string;
    }[];
    getReactions(myReaction?: string): {
        id: string;
        count: number;
        me: boolean;
        accounts: string[];
        url: string | null;
    }[];
    isReply: () => boolean;
    hasParentAvailable: () => boolean;
    getParentRaw: () => {
        id: string;
        createdAt: string;
        deletedAt?: string | null | undefined;
        text: string | null;
        cw?: string | null | undefined;
        userId: string;
        user: {
            id: string;
            name: string | null;
            username: string;
            host: string | null;
            avatarUrl: string;
            avatarBlurhash: string | null;
            avatarDecorations: {
                id: string;
                angle?: number | undefined;
                flipH?: boolean | undefined;
                url: string;
                offsetX?: number | undefined;
                offsetY?: number | undefined;
            }[];
            isBot?: boolean | undefined;
            isCat?: boolean | undefined;
            requireSigninToViewContents?: boolean | undefined;
            makeNotesFollowersOnlyBefore?: number | null | undefined;
            makeNotesHiddenBefore?: number | null | undefined;
            instance?: {
                name: string | null;
                softwareName: string | null;
                softwareVersion: string | null;
                iconUrl: string | null;
                faviconUrl: string | null;
                themeColor: string | null;
            } | undefined;
            emojis: {
                [key: string]: string;
            };
            onlineStatus: "active" | "offline" | "online" | "unknown";
            badgeRoles?: {
                name: string;
                iconUrl: string | null;
                displayOrder: number;
            }[] | undefined;
        };
        replyId?: string | null | undefined;
        renoteId?: string | null | undefined;
        reply?: any | null | undefined;
        renote?: any | null | undefined;
        isHidden?: boolean | undefined;
        visibility: "followers" | "home" | "public" | "specified";
        mentions?: string[] | undefined;
        visibleUserIds?: string[] | undefined;
        fileIds?: string[] | undefined;
        files?: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number | undefined;
                height?: number | undefined;
                orientation?: number | undefined;
                avgColor?: string | undefined;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: {
                id: string;
                createdAt: string;
                name: string;
                parentId: string | null;
                foldersCount?: number | undefined;
                filesCount?: number | undefined;
                parent?: any | null | undefined;
            } | null | undefined;
            userId: string | null;
            user?: {
                id: string;
                name: string | null;
                username: string;
                host: string | null;
                avatarUrl: string;
                avatarBlurhash: string | null;
                avatarDecorations: {
                    id: string;
                    angle?: number | undefined;
                    flipH?: boolean | undefined;
                    url: string;
                    offsetX?: number | undefined;
                    offsetY?: number | undefined;
                }[];
                isBot?: boolean | undefined;
                isCat?: boolean | undefined;
                requireSigninToViewContents?: boolean | undefined;
                makeNotesFollowersOnlyBefore?: number | null | undefined;
                makeNotesHiddenBefore?: number | null | undefined;
                instance?: {
                    name: string | null;
                    softwareName: string | null;
                    softwareVersion: string | null;
                    iconUrl: string | null;
                    faviconUrl: string | null;
                    themeColor: string | null;
                } | undefined;
                emojis: {
                    [key: string]: string;
                };
                onlineStatus: "active" | "offline" | "online" | "unknown";
                badgeRoles?: {
                    name: string;
                    iconUrl: string | null;
                    displayOrder: number;
                }[] | undefined;
            } | null | undefined;
        }[] | undefined;
        tags?: string[] | undefined;
        poll?: {
            expiresAt?: string | null | undefined;
            multiple: boolean;
            choices: {
                isVoted: boolean;
                text: string;
                votes: number;
            }[];
        } | null | undefined;
        emojis?: {
            [key: string]: string;
        } | undefined;
        channelId?: string | null | undefined;
        channel?: {
            id: string;
            name: string;
            color: string;
            isSensitive: boolean;
            allowRenoteToExternal: boolean;
            userId: string | null;
        } | null | undefined;
        localOnly?: boolean | undefined;
        reactionAcceptance: "likeOnly" | "likeOnlyForRemote" | "nonSensitiveOnly" | "nonSensitiveOnlyForLocalLikeOnlyForRemote" | null;
        reactionEmojis: {
            [key: string]: string;
        };
        reactions: {
            [key: string]: number;
        };
        reactionCount: number;
        renoteCount: number;
        repliesCount: number;
        uri?: string | undefined;
        url?: string | undefined;
        reactionAndUserPairCache?: string[] | undefined;
        clippedCount?: number | undefined;
        hasPoll?: boolean | undefined;
        myReaction?: string | null | undefined;
    } | null | undefined;
    isReposted: () => boolean;
    getReactionEmojis(): {
        height?: number | undefined;
        width?: number | undefined;
        name: string;
        url: string;
    }[];
    getIsSensitive: () => boolean;
    getSpoilerText: () => string | null | undefined;
    getRaw: () => {
        id: string;
        createdAt: string;
        deletedAt?: string | null | undefined;
        text: string | null;
        cw?: string | null | undefined;
        userId: string;
        user: {
            id: string;
            name: string | null;
            username: string;
            host: string | null;
            avatarUrl: string;
            avatarBlurhash: string | null;
            avatarDecorations: {
                id: string;
                angle?: number | undefined;
                flipH?: boolean | undefined;
                url: string;
                offsetX?: number | undefined;
                offsetY?: number | undefined;
            }[];
            isBot?: boolean | undefined;
            isCat?: boolean | undefined;
            requireSigninToViewContents?: boolean | undefined;
            makeNotesFollowersOnlyBefore?: number | null | undefined;
            makeNotesHiddenBefore?: number | null | undefined;
            instance?: {
                name: string | null;
                softwareName: string | null;
                softwareVersion: string | null;
                iconUrl: string | null;
                faviconUrl: string | null;
                themeColor: string | null;
            } | undefined;
            emojis: {
                [key: string]: string;
            };
            onlineStatus: "active" | "offline" | "online" | "unknown";
            badgeRoles?: {
                name: string;
                iconUrl: string | null;
                displayOrder: number;
            }[] | undefined;
        };
        replyId?: string | null | undefined;
        renoteId?: string | null | undefined;
        reply?: any | null | undefined;
        renote?: any | null | undefined;
        isHidden?: boolean | undefined;
        visibility: "followers" | "home" | "public" | "specified";
        mentions?: string[] | undefined;
        visibleUserIds?: string[] | undefined;
        fileIds?: string[] | undefined;
        files?: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number | undefined;
                height?: number | undefined;
                orientation?: number | undefined;
                avgColor?: string | undefined;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: {
                id: string;
                createdAt: string;
                name: string;
                parentId: string | null;
                foldersCount?: number | undefined;
                filesCount?: number | undefined;
                parent?: any | null | undefined;
            } | null | undefined;
            userId: string | null;
            user?: {
                id: string;
                name: string | null;
                username: string;
                host: string | null;
                avatarUrl: string;
                avatarBlurhash: string | null;
                avatarDecorations: {
                    id: string;
                    angle?: number | undefined;
                    flipH?: boolean | undefined;
                    url: string;
                    offsetX?: number | undefined;
                    offsetY?: number | undefined;
                }[];
                isBot?: boolean | undefined;
                isCat?: boolean | undefined;
                requireSigninToViewContents?: boolean | undefined;
                makeNotesFollowersOnlyBefore?: number | null | undefined;
                makeNotesHiddenBefore?: number | null | undefined;
                instance?: {
                    name: string | null;
                    softwareName: string | null;
                    softwareVersion: string | null;
                    iconUrl: string | null;
                    faviconUrl: string | null;
                    themeColor: string | null;
                } | undefined;
                emojis: {
                    [key: string]: string;
                };
                onlineStatus: "active" | "offline" | "online" | "unknown";
                badgeRoles?: {
                    name: string;
                    iconUrl: string | null;
                    displayOrder: number;
                }[] | undefined;
            } | null | undefined;
        }[] | undefined;
        tags?: string[] | undefined;
        poll?: {
            expiresAt?: string | null | undefined;
            multiple: boolean;
            choices: {
                isVoted: boolean;
                text: string;
                votes: number;
            }[];
        } | null | undefined;
        emojis?: {
            [key: string]: string;
        } | undefined;
        channelId?: string | null | undefined;
        channel?: {
            id: string;
            name: string;
            color: string;
            isSensitive: boolean;
            allowRenoteToExternal: boolean;
            userId: string | null;
        } | null | undefined;
        localOnly?: boolean | undefined;
        reactionAcceptance: "likeOnly" | "likeOnlyForRemote" | "nonSensitiveOnly" | "nonSensitiveOnlyForLocalLikeOnlyForRemote" | null;
        reactionEmojis: {
            [key: string]: string;
        };
        reactions: {
            [key: string]: number;
        };
        reactionCount: number;
        renoteCount: number;
        repliesCount: number;
        uri?: string | undefined;
        url?: string | undefined;
        reactionAndUserPairCache?: string[] | undefined;
        clippedCount?: number | undefined;
        hasPoll?: boolean | undefined;
        myReaction?: string | null | undefined;
    };
    getIsFavourited(): boolean | null | undefined;
    getUser: () => {
        id: string;
        name: string | null;
        username: string;
        host: string | null;
        avatarUrl: string;
        avatarBlurhash: string | null;
        avatarDecorations: {
            id: string;
            angle?: number | undefined;
            flipH?: boolean | undefined;
            url: string;
            offsetX?: number | undefined;
            offsetY?: number | undefined;
        }[];
        isBot?: boolean | undefined;
        isCat?: boolean | undefined;
        requireSigninToViewContents?: boolean | undefined;
        makeNotesFollowersOnlyBefore?: number | null | undefined;
        makeNotesHiddenBefore?: number | null | undefined;
        instance?: {
            name: string | null;
            softwareName: string | null;
            softwareVersion: string | null;
            iconUrl: string | null;
            faviconUrl: string | null;
            themeColor: string | null;
        } | undefined;
        emojis: {
            [key: string]: string;
        };
        onlineStatus: "active" | "offline" | "online" | "unknown";
        badgeRoles?: {
            name: string;
            iconUrl: string | null;
            displayOrder: number;
        }[] | undefined;
    };
    getParentStatusId: () => string | null | undefined;
    getUserIdParentStatusUserId(): string | null | undefined;
    getRepostedStatusRaw: () => {
        id: string;
        createdAt: string;
        deletedAt?: string | null | undefined;
        text: string | null;
        cw?: string | null | undefined;
        userId: string;
        user: {
            id: string;
            name: string | null;
            username: string;
            host: string | null;
            avatarUrl: string;
            avatarBlurhash: string | null;
            avatarDecorations: {
                id: string;
                angle?: number | undefined;
                flipH?: boolean | undefined;
                url: string;
                offsetX?: number | undefined;
                offsetY?: number | undefined;
            }[];
            isBot?: boolean | undefined;
            isCat?: boolean | undefined;
            requireSigninToViewContents?: boolean | undefined;
            makeNotesFollowersOnlyBefore?: number | null | undefined;
            makeNotesHiddenBefore?: number | null | undefined;
            instance?: {
                name: string | null;
                softwareName: string | null;
                softwareVersion: string | null;
                iconUrl: string | null;
                faviconUrl: string | null;
                themeColor: string | null;
            } | undefined;
            emojis: {
                [key: string]: string;
            };
            onlineStatus: "active" | "offline" | "online" | "unknown";
            badgeRoles?: {
                name: string;
                iconUrl: string | null;
                displayOrder: number;
            }[] | undefined;
        };
        replyId?: string | null | undefined;
        renoteId?: string | null | undefined;
        reply?: any | null | undefined;
        renote?: any | null | undefined;
        isHidden?: boolean | undefined;
        visibility: "followers" | "home" | "public" | "specified";
        mentions?: string[] | undefined;
        visibleUserIds?: string[] | undefined;
        fileIds?: string[] | undefined;
        files?: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number | undefined;
                height?: number | undefined;
                orientation?: number | undefined;
                avgColor?: string | undefined;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: {
                id: string;
                createdAt: string;
                name: string;
                parentId: string | null;
                foldersCount?: number | undefined;
                filesCount?: number | undefined;
                parent?: any | null | undefined;
            } | null | undefined;
            userId: string | null;
            user?: {
                id: string;
                name: string | null;
                username: string;
                host: string | null;
                avatarUrl: string;
                avatarBlurhash: string | null;
                avatarDecorations: {
                    id: string;
                    angle?: number | undefined;
                    flipH?: boolean | undefined;
                    url: string;
                    offsetX?: number | undefined;
                    offsetY?: number | undefined;
                }[];
                isBot?: boolean | undefined;
                isCat?: boolean | undefined;
                requireSigninToViewContents?: boolean | undefined;
                makeNotesFollowersOnlyBefore?: number | null | undefined;
                makeNotesHiddenBefore?: number | null | undefined;
                instance?: {
                    name: string | null;
                    softwareName: string | null;
                    softwareVersion: string | null;
                    iconUrl: string | null;
                    faviconUrl: string | null;
                    themeColor: string | null;
                } | undefined;
                emojis: {
                    [key: string]: string;
                };
                onlineStatus: "active" | "offline" | "online" | "unknown";
                badgeRoles?: {
                    name: string;
                    iconUrl: string | null;
                    displayOrder: number;
                }[] | undefined;
            } | null | undefined;
        }[] | undefined;
        tags?: string[] | undefined;
        poll?: {
            expiresAt?: string | null | undefined;
            multiple: boolean;
            choices: {
                isVoted: boolean;
                text: string;
                votes: number;
            }[];
        } | null | undefined;
        emojis?: {
            [key: string]: string;
        } | undefined;
        channelId?: string | null | undefined;
        channel?: {
            id: string;
            name: string;
            color: string;
            isSensitive: boolean;
            allowRenoteToExternal: boolean;
            userId: string | null;
        } | null | undefined;
        localOnly?: boolean | undefined;
        reactionAcceptance: "likeOnly" | "likeOnlyForRemote" | "nonSensitiveOnly" | "nonSensitiveOnlyForLocalLikeOnlyForRemote" | null;
        reactionEmojis: {
            [key: string]: string;
        };
        reactions: {
            [key: string]: number;
        };
        reactionCount: number;
        renoteCount: number;
        repliesCount: number;
        uri?: string | undefined;
        url?: string | undefined;
        reactionAndUserPairCache?: string[] | undefined;
        clippedCount?: number | undefined;
        hasPoll?: boolean | undefined;
        myReaction?: string | null | undefined;
    } | null | undefined;
    getId: () => string;
    getRepliesCount: () => number;
    getRepostsCount: () => number;
    getUsername: () => string;
    getDisplayName: () => string | null;
    getAvatarUrl: () => string;
    getCreatedAt: () => string;
    getVisibility: () => "followers" | "home" | "public" | "specified";
    getAccountUrl(mySubdomain?: string): string;
    getRepostedStatus(): PostTargetInterface | null | undefined;
    getQuote(): PostTargetInterface | null | undefined;
    getMediaAttachments(): any[];
    getContent: () => string | null;
    getFacets: () => never[];
    print(): void;
    getAccountId_Poster: () => string;
    getMyReaction: () => string | null | undefined;
}
export default MisskeyApiPostAdapter;
//# sourceMappingURL=misskey.d.ts.map