import { MediaAttachmentToMediaAttachmentAdapter } from '../media-attachment/adapter.js';
import { MediaAttachmentInstance } from '../media-attachment/unique.js';
import PostAdapterBase from './default.js';
import { CasingUtil } from '../../utils/casing.js';
class MastoApiPostAdapter extends PostAdapterBase {
    ref;
    constructor(ref) {
        super();
        this.ref = ref;
    }
    getCachedEmojis() {
        const retval = new Map();
        this.ref.emojis?.forEach((o) => {
            retval.set(o.shortcode, o.url);
        });
        return retval;
    }
    getMentions() {
        return this.ref.mentions || [];
    }
    getReactions() {
        let reactions = this.ref.emojiReactions;
        if (!reactions) {
            reactions = this.ref?.pleroma?.emojiReactions;
        }
        if (!reactions)
            return [];
        return reactions.map((o) => ({
            id: o.name,
            count: o.count,
            me: o.me || false,
            accounts: o.accountIds || [],
            url: o.url,
        }));
    }
    getIsRebloggedByMe() {
        return this.ref.reblogged;
    }
    getIsSensitive() {
        return this.ref.sensitive;
    }
    getSpoilerText() {
        return this.ref.spoilerText;
    }
    getRaw = () => this.ref;
    getIsFavourited = () => this.ref.favourited;
    getUser = () => this.ref.account;
    isReply() {
        return (this.ref.inReplyToId !== '' &&
            this.ref.inReplyToId !== null &&
            this.ref.inReplyToId !== undefined);
    }
    getParentStatusId = () => this.ref.inReplyToId;
    getUserIdParentStatusUserId = () => this.ref.inReplyToAccountId;
    getIsBookmarked = () => this.ref.bookmarked;
    getId = () => this.ref.id;
    getRepliesCount = () => this.ref.repliesCount;
    getRepostsCount = () => this.ref.reblogsCount;
    getFavouritesCount = () => this.ref.favouritesCount;
    getUsername = () => this.ref.account.username || '';
    getDisplayName = () => this.ref.account.displayName || '';
    getAvatarUrl = () => this.ref.account.avatarStatic || '';
    getCreatedAt = () => this.ref.createdAt || new Date().toString();
    getVisibility = () => this.ref.visibility;
    getAccountUrl = () => this.ref.account.uri || this.ref.account.url;
    getRepostedStatus() {
        if (this.ref.reblog) {
            return new MastoApiPostAdapter(this.ref.reblog);
        }
        return null;
    }
    getQuote = () => this.ref.quote;
    getRepostedStatusRaw = () => this.ref.reblog;
    isReposted = () => !!this.ref.reblog;
    getMediaAttachments() {
        return this.ref.mediaAttachments?.map((o) => {
            return new MediaAttachmentToMediaAttachmentAdapter(new MediaAttachmentInstance(CasingUtil.camelCaseKeys(o)));
        });
    }
    getContent = () => this.ref.content;
    getFacets = () => [];
    print() {
        console.log(this.ref);
    }
    getAccountId_Poster = () => this.ref.account?.id;
}
export default MastoApiPostAdapter;
//# sourceMappingURL=mastodon.js.map