import { DhaagaJsMentionObject, PostTargetInterface } from './_interface.js';
import { MediaAttachmentToMediaAttachmentAdapter } from '../media-attachment/adapter.js';
import PostAdapterBase from './default.js';
import type { MastoStatus } from '../../types/mastojs.types.js';
declare class MastoApiPostAdapter extends PostAdapterBase implements PostTargetInterface {
    ref: MastoStatus;
    constructor(ref: MastoStatus);
    getCachedEmojis(): Map<string, string>;
    getMentions(): DhaagaJsMentionObject[];
    getReactions(): {
        id: string;
        count: number;
        me: boolean;
        accounts: string[];
        url: string | null;
    }[];
    getIsRebloggedByMe(): boolean | null | undefined;
    getIsSensitive(): boolean;
    getSpoilerText(): string | null | undefined;
    getRaw: () => any;
    getIsFavourited: () => boolean | null | undefined;
    getUser: () => any;
    isReply(): boolean;
    getParentStatusId: () => string | null | undefined;
    getUserIdParentStatusUserId: () => string | null | undefined;
    getIsBookmarked: () => boolean | null | undefined;
    getId: () => string;
    getRepliesCount: () => number;
    getRepostsCount: () => number;
    getFavouritesCount: () => number;
    getUsername: () => string;
    getDisplayName: () => string;
    getAvatarUrl: () => string;
    getCreatedAt: () => string;
    getVisibility: () => keyof import("masto/mastodon/entities/v1/status.js").StatusVisibilityRegistry;
    getAccountUrl: () => any;
    getRepostedStatus(): MastoApiPostAdapter | null;
    getQuote: () => any;
    getRepostedStatusRaw: () => any;
    isReposted: () => boolean;
    getMediaAttachments(): MediaAttachmentToMediaAttachmentAdapter[];
    getContent: () => string;
    getFacets: () => never[];
    print(): void;
    getAccountId_Poster: () => string;
}
export default MastoApiPostAdapter;
//# sourceMappingURL=mastodon.d.ts.map