import { UserType } from '../profile/_interface.js';
import { DhaagaJsMentionObject, Status, PostTargetInterface } from './_interface.js';
import { PostView } from '@atproto/api/dist/client/types/app/bsky/feed/defs.js';
import type { MediaAttachmentTargetInterface } from '../media-attachment/_interface.js';
declare class PostAdapterBase implements PostTargetInterface {
    getCid(): string | null;
    getUri(): string | null;
    hasParentAvailable(): boolean;
    getParentRaw(): Status | PostView | null;
    hasRootAvailable(): boolean;
    getRootRaw(): undefined;
    hasQuoteAvailable(): boolean;
    getQuoteRaw(): PostView | undefined | null;
    getMentions(): DhaagaJsMentionObject[];
    getMyReaction(): string | null | undefined;
    getCachedEmojis(): Map<string, string>;
    getReactions(): {
        id: string;
        count: number;
        me: boolean;
        accounts: string[];
        url: string | null;
    }[];
    getReactionEmojis(): {
        height?: number | undefined;
        width?: number | undefined;
        name: string;
        url: string;
    }[];
    getIsRebloggedByMe(): boolean | null | undefined;
    getIsSensitive(): boolean;
    getSpoilerText(): string | null | undefined;
    getRaw(): Status;
    getUser(): UserType;
    isReply(): boolean;
    getParentStatusId(): string | null | undefined;
    getUserIdParentStatusUserId(): string | null | undefined;
    getRepostedStatusRaw(): Status;
    getQuote(): PostTargetInterface | null | undefined;
    getIsBookmarked(): boolean | null | undefined;
    getIsFavourited(): boolean | null | undefined;
    getRepliesCount(): number;
    getId(): string;
    getRepostsCount(): number;
    getFavouritesCount(): number;
    getUsername(): string;
    getDisplayName(): string | null | undefined;
    getAvatarUrl(): string | null | undefined;
    getCreatedAt(): string;
    getVisibility(): string;
    getAccountUrl(): string;
    getRepostedStatus(): PostTargetInterface | null | undefined;
    isReposted(): boolean;
    getContent(): string | null | undefined;
    getFacets: () => never[];
    getMediaAttachments(): MediaAttachmentTargetInterface[];
    print(): void;
    getAccountId_Poster(): string;
}
export default PostAdapterBase;
//# sourceMappingURL=default.d.ts.map