import { EmbedViewProcessor_External, EmbedViewProcessor_Images, EmbedViewProcessor_RecordWithMedia, EmbedViewProcessor_Video, } from '../media-attachment/bluesky.js';
import { AppBskyRichtextFacet } from '@atproto/api';
class AtprotoPostAdapter {
    post;
    reply;
    reason;
    constructor({ post, reply, reason, }) {
        this.post = post;
        this.reply = reply;
        this.reason = reason;
    }
    getCid = () => this.post.cid;
    getUri = () => this.post.uri;
    getLikeUri = () => this.post.viewer?.like;
    getEmbeddingDisabled = () => this.post.viewer?.embeddingDisabled;
    getPinUri = () => this.post.viewer?.pinned;
    getRepostUri = () => this.post.viewer?.repost;
    getReplyDisabled = () => this.post.viewer?.replyDisabled;
    getThreadMuted = () => this.post.viewer?.threadMuted;
    getViewer = () => this.post.viewer;
    hasQuoteAvailable() {
        return this.post.embed && this.isQuote();
    }
    getQuoteRaw() {
        return this.post.embed.record;
    }
    getRaw = () => this.post;
    getId = () => this.post?.uri;
    getUsername = () => this.post?.author?.handle;
    getDisplayName = () => this.post?.author?.displayName;
    getAvatarUrl = () => this.post?.author?.avatar;
    getCreatedAt = () => {
        if (this.isShare())
            return this.reason?.indexedAt;
        return this.post.record?.createdAt || this.post.indexedAt;
    };
    getVisibility() {
        return 'public';
    }
    getAccountUrl(mySubdomain) {
        return `https://bsky.app/profile/${this.post?.author?.handle}`;
    }
    getRepostedStatus() {
        if (this.isShare()) {
            const { post, ...rest } = this;
            return new AtprotoPostAdapter({
                post: this.post,
                reason: null,
                reply: null,
            });
        }
        else if (this.isQuote()) {
            if (this.post.embed?.$type === 'app.bsky.embed.recordWithMedia#view') {
                return new AtprotoPostAdapter({
                    post: this.post.embed?.record?.record,
                    reason: null,
                    reply: null,
                });
            }
            else {
                return new AtprotoPostAdapter({
                    post: this.post.embed?.record,
                    reason: null,
                    reply: null,
                });
            }
        }
        return null;
    }
    getRepostedStatusRaw() {
        if (this.isShare()) {
            const { post, ...rest } = this;
            return { post };
        }
        if (this.isQuote()) {
            switch (this.post.embed?.$type) {
                case 'app.bsky.embed.recordWithMedia#view': {
                    return { post: this.post.embed?.record?.record };
                }
                case 'app.bsky.embed.record#view': {
                    return { post: this.post.embed?.record };
                }
                default:
                    return null;
            }
        }
        return null;
    }
    hasParentAvailable = () => !!this.reply?.parent;
    getParentRaw = () => this.reply?.parent;
    hasRootAvailable = () => !!this.reply?.root;
    getRootRaw = () => this.reply?.root;
    getContent() {
        if (this.isShare())
            return null;
        return this.post?.record?.text || this.post?.value?.text;
    }
    getFacets() {
        if (this.isShare())
            return [];
        return this.post?.record?.facets || [];
    }
    getUser() {
        if (this.isShare())
            return this.reason.by;
        return this.post.author;
    }
    isQuote = () => this.post.embed?.$type === 'app.bsky.embed.record#view' ||
        this.post.embed?.$type === 'app.bsky.embed.recordWithMedia#view';
    isShare = () => this.reason?.$type === 'app.bsky.feed.defs#reasonRepost';
    isReposted = () => this.isShare() || this.isQuote();
    getMediaAttachments() {
        if (this.reason?.$type === 'app.bsky.feed.defs#reasonRepost') {
            return [];
        }
        if (EmbedViewProcessor_External.isCompatible(this.post.embed))
            return EmbedViewProcessor_External.compile(this.post.embed);
        if (EmbedViewProcessor_RecordWithMedia.isCompatible(this.post.embed))
            return EmbedViewProcessor_RecordWithMedia.compile(this.post.embed);
        if (this.post.$type === 'app.bsky.embed.record#viewRecord') {
            const embeds = this.post.embeds;
            if (embeds && Array.isArray(embeds)) {
                const attachments = [];
                for (const embed of embeds) {
                    if (EmbedViewProcessor_Images.isCompatible(embed))
                        attachments.push(...EmbedViewProcessor_Images.compile(embed));
                    if (EmbedViewProcessor_Video.isCompatible(embed))
                        attachments.push(...EmbedViewProcessor_Video.compile(embed));
                }
                return attachments;
            }
        }
        else if (this.reason?.$type === 'app.bsky.feed.defs#reasonRepost') {
            return [];
        }
        if (EmbedViewProcessor_Images.isCompatible(this.post.embed))
            return EmbedViewProcessor_Images.compile(this.post.embed);
        if (EmbedViewProcessor_Video.isCompatible(this.post.embed))
            return EmbedViewProcessor_Video.compile(this.post.embed);
        return [];
    }
    getMentions() {
        const facets = this.post?.record?.facets;
        if (facets) {
            facets
                .filter((o) => o.features.every(AppBskyRichtextFacet.isMention))
                .map((o) => ({ id: o.features[0].did }));
        }
        return [];
    }
    print() {
        console.log(this.post);
    }
    getIsRebloggedByMe = () => this.post.viewer?.repost !== undefined;
    getIsFavourited = () => false;
    getRepostsCount = () => this.post?.repostCount || 0;
    getRepliesCount = () => this.post?.replyCount || 0;
    getFavouritesCount = () => this.post?.likeCount || 0;
    getQuoteCount = () => this.post?.quoteCount || 0;
    getAccountId_Poster() {
        throw new Error('Method not implemented.');
    }
    isValid = () => true;
    isReply = () => !!this.reply;
    getParentStatusId() {
        return null;
    }
    getUserIdParentStatusUserId() {
        return null;
    }
    getIsSensitive = () => false;
    getSpoilerText = () => null;
    setDescendents = (items) => [];
    getDescendants = () => [];
    getReactions = () => [];
    getCachedEmojis = () => new Map();
    getReactionEmojis = () => [];
    getMyReaction = () => null;
    getQuote = () => null;
    getIsBookmarked = () => false;
}
export default AtprotoPostAdapter;
//# sourceMappingURL=bluesky.js.map