import MisskeyApiPostAdapter from './misskey.js';
import MastoApiPostAdapter from './mastodon.js';
import AtprotoPostAdapter from './bluesky.js';
import { CasingUtil } from '../../utils/casing.js';
import { DriverService } from '../../services/driver.js';
export function ActivitypubStatusAdapter(status, driver) {
    if (DriverService.supportsMisskeyApi(driver))
        return new MisskeyApiPostAdapter(status);
    if (DriverService.supportsPleromaApi(driver)) {
        const _camel = CasingUtil.camelCaseKeys(status);
        return new MastoApiPostAdapter(_camel);
    }
    if (DriverService.supportsAtProto(driver)) {
        if (status?.['$type'] === 'app.bsky.feed.defs#blockedPost')
            return null;
        return new AtprotoPostAdapter(status?.post
            ? {
                post: status.post,
                reply: status.reply,
                reason: status.reason,
            }
            : {
                post: status,
                reply: undefined,
                reason: undefined,
            });
    }
    if (DriverService.supportsMastoApiV2(driver)) {
        return new MastoApiPostAdapter(status);
    }
    console.log('[WARN]: driver not handled', driver);
    return null;
}
//# sourceMappingURL=_adapters.js.map