import { UserTargetInterface } from './_interface.js';
import { AppBskyActorDefs } from '@atproto/api';
export declare class BlueskyUserInterface implements UserTargetInterface {
    ref: AppBskyActorDefs.ProfileViewDetailed;
    constructor(ref: AppBskyActorDefs.ProfileViewDetailed);
    getPinnedNotes: () => never[];
    getInstanceUrl: (subdomain: string) => string;
    getIsLockedProfile: () => boolean;
    private extractInstanceUrl;
    getId: () => string;
    getDisplayName: () => string | undefined;
    getAccountUrl: () => string;
    getAppDisplayAccountUrl: (myDomain: string) => string;
    getUsername: () => string;
    getAvatarUrl: () => string | undefined;
    getCreatedAt: () => Date;
    getEmojiMap: () => Map<string, string>;
    findEmoji(q: string): undefined;
    isValid: () => boolean;
    getAvatarBlurHash: () => null;
    getBannerUrl: () => string | undefined;
    getBannerBlurHash: () => null;
    getDescription: () => string | undefined;
    getBirthday: () => Date;
    getFields(): any[];
    getFollowersCount: () => number;
    getFollowingCount: () => number;
    hasPendingFollowRequestFromYou: () => boolean;
    hasPendingFollowRequestToYou: () => boolean;
    getIsBot: () => boolean;
    getPostCount: () => number;
    getOnlineStatus: () => any;
    getKnownFollowers(): never[] | AppBskyActorDefs.KnownFollowers;
}
export default BlueskyUserInterface;
//# sourceMappingURL=bluesky.d.ts.map