import { z } from 'zod';
import { MediaAttachmentTargetInterface } from './_interface.js';
declare class BlueskyMediaAttachmentAdapter implements MediaAttachmentTargetInterface {
    item: BskyImageEmbedItem;
    constructor(ref: BskyImageEmbedItem);
    static create(ref: BskyImageEmbedItem): BlueskyMediaAttachmentAdapter;
    getId(): string;
    getAltText: () => string;
    getBlurHash: () => null;
    getCreatedAt: () => string;
    getMeta: () => void;
    getName: () => string;
    getPreviewUrl: () => string;
    getUrl: () => string;
    getHeight: () => number;
    getWidth: () => number;
    getType(): string;
    print(): void;
}
declare class BlueskyVideoAttachmentAdapter implements MediaAttachmentTargetInterface {
    item: BskyVideoEmbedType;
    constructor(ref: BskyVideoEmbedType);
    static create(ref: BskyVideoEmbedType): BlueskyVideoAttachmentAdapter;
    getId(): string;
    getAltText: () => null;
    getBlurHash: () => null;
    getCreatedAt: () => string;
    getMeta: () => void;
    getName: () => string;
    getPreviewUrl: () => string;
    getUrl: () => string;
    getHeight: () => number;
    getWidth: () => number;
    getType(): string;
    print(): void;
}
export declare const bskyEmbedExternalSchema: z.ZodObject<{
    $type: z.ZodLiteral<"app.bsky.embed.external#view">;
    external: z.ZodObject<{
        uri: z.ZodString;
        title: z.ZodString;
        description: z.ZodString;
        thumb: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>;
type BskyEmbedExternalType = z.infer<typeof bskyEmbedExternalSchema>;
declare class EmbedViewProcessor_External implements MediaAttachmentTargetInterface {
    item: BskyEmbedExternalType;
    constructor(obj: BskyEmbedExternalType);
    static create(obj: BskyEmbedExternalType): EmbedViewProcessor_External;
    static isCompatible(obj: any): boolean;
    static compile(obj: any): MediaAttachmentTargetInterface[];
    getId(): string;
    getAltText: () => string;
    getBlurHash: () => null;
    getCreatedAt: () => string;
    getMeta: () => void;
    getName: () => string;
    getPreviewUrl: () => string;
    getUrl: () => string;
    getHeight: () => null;
    getWidth: () => null;
    getType(): string;
    print(): void;
}
declare const bskyEmbedImagesSchemaImageItem: z.ZodObject<{
    alt: z.ZodString;
    aspectRatio: z.ZodObject<{
        height: z.ZodNumber;
        width: z.ZodNumber;
    }, z.core.$strip>;
    thumb: z.ZodString;
    fullsize: z.ZodString;
}, z.core.$strip>;
type BskyImageEmbedItem = z.infer<typeof bskyEmbedImagesSchemaImageItem>;
declare class EmbedViewProcessor_Images {
    static isCompatible(obj: any): boolean;
    static compile(obj: any): MediaAttachmentTargetInterface[];
}
declare const bskyEmbedVideoSchema: z.ZodObject<{
    $type: z.ZodLiteral<"app.bsky.embed.video#view">;
    cid: z.ZodString;
    playlist: z.ZodString;
    thumbnail: z.ZodString;
    aspectRatio: z.ZodObject<{
        height: z.ZodNumber;
        width: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>;
type BskyVideoEmbedType = z.infer<typeof bskyEmbedVideoSchema>;
declare class EmbedViewProcessor_Video {
    static isCompatible(obj: any): boolean;
    static compile(obj: any): MediaAttachmentTargetInterface[];
}
declare class EmbedViewProcessor_RecordWithMedia {
    static isCompatible(obj: any): boolean;
    static compile(obj: any): MediaAttachmentTargetInterface[];
}
export { EmbedViewProcessor_External, EmbedViewProcessor_Images, EmbedViewProcessor_RecordWithMedia, EmbedViewProcessor_Video, BlueskyMediaAttachmentAdapter, BlueskyVideoAttachmentAdapter, };
//# sourceMappingURL=bluesky.d.ts.map