import { LibraryResponse } from '../types/result.types.js';
type DhaagaFetchRequestConfig = {
    method?: 'GET' | 'POST' | 'PUT' | 'DELETE' | 'OPTIONS' | 'PATCH';
    baseURL?: string;
    accessToken?: string;
    queries?: Object | Record<string, string>;
    transformQueryKeys?: 'snake' | 'camel';
    transformQueryValues?: 'snake' | 'camel';
    transformResponse?: 'snake' | 'camel';
};
declare class FetchWrapper {
    baseUrl: string;
    token?: string;
    requestHeader: HeadersInit;
    constructor(urlLike: string, token?: string);
    static create(urlLike: string, token?: string): FetchWrapper;
    private static cleanObject;
    private withQuery;
    getCamelCaseWithLinkPagination<T>(endpoint: string, query?: Object | Record<string, string>): Promise<LibraryResponse<{
        data: T;
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getCamelCase<T>(endpoint: string, query?: Object | Record<string, string>): Promise<LibraryResponse<T>>;
    post<T>(endpoint: string, body: object, opts: {}): Promise<LibraryResponse<T>>;
    private static applyQueriesToRequestUrl;
    private static buildRequestInitObject;
    private static execute;
    get<T>(endpoint: string, opts?: DhaagaFetchRequestConfig): Promise<LibraryResponse<T>>;
}
export default FetchWrapper;
//# sourceMappingURL=custom-fetch.d.ts.map