import FetchWrapper from './custom-fetch.js';
import { createRestAPIClient } from 'masto';
import { Agent, CredentialSession } from '@atproto/api';
import generator from 'megalodon';
import { KNOWN_SOFTWARE } from '../data/driver.js';
import { api } from 'misskey-js';
export class AtProtoWrapper extends FetchWrapper {
    lib;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.lib = new Agent(new CredentialSession(new URL(this.baseUrl)));
    }
    static create(baseUrl, token) {
        return new AtProtoWrapper(baseUrl, token);
    }
}
export class MastoJsWrapper extends FetchWrapper {
    lib;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.lib = createRestAPIClient({
            url: this.baseUrl,
            accessToken: this.token || undefined,
        });
    }
    static create(baseUrl, token) {
        return new MastoJsWrapper(baseUrl, token);
    }
}
export class MegalodonPleromaWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = generator(KNOWN_SOFTWARE.PLEROMA, this.baseUrl, this.token || undefined);
    }
    static create(baseUrl, token) {
        return new MegalodonPleromaWrapper(baseUrl, token);
    }
}
export class MegalodonGoToSocialWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = generator(KNOWN_SOFTWARE.GOTOSOCIAL, this.baseUrl, this.token || undefined);
    }
    static create(baseUrl, token) {
        return new MegalodonGoToSocialWrapper(baseUrl, token);
    }
}
export class MisskeyJsWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = new api.APIClient({
            origin: this.baseUrl,
            credential: this.token || undefined,
        });
    }
    static create(baseUrl, token) {
        return new MisskeyJsWrapper(baseUrl, token);
    }
}
//# sourceMappingURL=custom-clients.js.map