import { errorBuilder } from '../adapters/_client/_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../types/result.types.js';
export async function InvokeBskyFunction(name, fn, agent, params, headers) {
    try {
        const data = params
            ? headers
                ? await fn.call(agent, params, headers)
                : await fn.call(agent, params)
            : headers
                ? fn.call(agent, headers)
                : fn.call(agent);
        if (!data.success) {
            console.log('[WARN]: atproto agent returned failure', name);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
        return { data: data.data };
    }
    catch (e) {
        console.log('[WARN]: atproto agent failed request', name, e);
        return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
    }
}
export async function InvokeBskyFunction_Improved(name, fn, agent, params, headers) {
    const data = params
        ? headers
            ? await fn.call(agent, params, headers)
            : await fn.call(agent, params)
        : headers
            ? fn.call(agent, headers)
            : fn.call(agent);
    if (!data.success) {
        console.log('[WARN]: atproto agent returned failure', name);
        throw new Error(ApiErrorCode.UNKNOWN_ERROR);
    }
    return data.data;
}
//# sourceMappingURL=custom-bsky-agent.js.map