import { CredentialSession, } from '@atproto/api';
import { jwtDecode } from 'jwt-decode';
import { BaseUrlNormalizationService } from '../utils/urls.js';
const DEFAULT_SERVICE_URL = 'https://bsky.social';
class AtProtoAuthService {
    static async loginWithPassword(username, password, service = DEFAULT_SERVICE_URL) {
        if (!username || !password)
            return null;
        let storedSession = null;
        const session = new CredentialSession(new URL(service), fetch, (evt, session1) => {
            storedSession = session1;
        });
        try {
            await session.login({
                identifier: username.includes('.')
                    ? username
                    : `${username}.bsky.social`,
                password,
            });
            if (!session.session)
                return null;
            return {
                sessionData: session.session,
                pdsUrl: session.pdsUrl.toString(),
                serviceUrl: session.serviceUrl.toString(),
                session,
            };
        }
        catch (e) {
            return null;
        }
    }
    static isTokenExpired(input) {
        const jwtString = typeof input === 'string' ? input : input.accessJwt;
        if (!jwtString)
            return true;
        const jwt = jwtDecode(jwtString);
        if (!jwt)
            return true;
        return jwt.exp < Math.floor(new Date().getTime() / 1000);
    }
    static async resumeSession(obj, serviceUrl = DEFAULT_SERVICE_URL) {
        let nextEvt = null;
        let nextSession = null;
        function evtHandler(evt, session) {
            nextEvt = evt;
            nextSession = session;
        }
        const cs = AtProtoAuthService.createEmptyCredentialSession(serviceUrl, evtHandler);
        cs.session = obj;
        await cs.refreshSession();
        if (!nextEvt)
            return null;
        switch (nextEvt) {
            case 'update': {
                return { nextSession: nextSession, pdsUrl: cs.pdsUrl.toString() };
            }
            case 'expired': {
                return null;
            }
            case 'network-error': {
                return null;
            }
            default: {
                return null;
            }
        }
    }
    static async exchangeCodeForSession(code, verifier, pds) {
        const body = {
            grant_type: 'authorization_code',
            redirect_uri: 'https://suvam.io/dhaaga',
            code,
            code_verifier: verifier,
            client_id: 'https://suvam.io/dhaaga/client-metadata.json',
        };
        const response = await fetch(pds ? `https://${pds}/oauth/token` : 'https://bsky.social/oauth/token', {
            method: 'POST',
            body: JSON.stringify(body),
            headers: {
                'Content-Type': 'application/json',
            },
        });
        if (!response.ok) {
            console.log(response);
            return null;
        }
        const data = await response.json();
        console.log(data);
        return data;
    }
    static createEmptyCredentialSession(serviceUrl, cb) {
        return new CredentialSession(new URL(BaseUrlNormalizationService.appendHttps(serviceUrl)), fetch, cb);
    }
}
export default AtProtoAuthService;
//# sourceMappingURL=atproto.js.map