import { DefaultTimelinesRouter } from '../default/timelines.js';
import { CasingUtil } from '../../../utils/casing.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { ApiErrorCode } from '../../../types/result.types.js';
export class PleromaTimelinesRouter extends DefaultTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        super();
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async home(query) {
        try {
            const data = await this.client.client.getHomeTimeline(CasingUtil.snakeCaseKeys(query));
            return data.data;
        }
        catch (e) {
            throw new Error(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async public(query) {
        if (query.local === true) {
            const data = await this.client.client.getLocalTimeline(CasingUtil.snakeCaseKeys(query));
            return data.data;
        }
        else {
            const data = await this.client.client.getPublicTimeline(CasingUtil.snakeCaseKeys(query));
            return data.data;
        }
    }
    async bubble(query) {
        const { data: _data, error } = await this.direct.get('/api/v1/timelines/bubble', {
            queries: CasingUtil.snakeCaseKeys(query),
        });
        if (error)
            throw new Error(error.code);
        return CasingUtil.camelCaseKeys(_data);
    }
    async list(q, query) {
        const data = await this.client.client.getListTimeline(q, CasingUtil.snakeCaseKeys(query));
        return data.data;
    }
    async hashtag(q, query) {
        const data = await this.client.client.getTagTimeline(q, CasingUtil.snakeCaseKeys(query));
        return data.data;
    }
}
//# sourceMappingURL=timelines.js.map