import { DhaagaJsPostCreateDto, StatusesRoute } from '../_router/routes/statuses.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MegaReaction, MegaScheduledStatus, MegaStatus } from '../../../types/megalodon.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '../../../types/driver.types.js';
export declare class PleromaStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    get(id: string): LibraryPromise<MegaStatus>;
    create(dto: DhaagaJsPostCreateDto): LibraryPromise<MegaStatus | MegaScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    getReactions(id: string): Promise<LibraryResponse<MegaReaction[]>>;
    getReactionDetails(postId: string, reactionId: string): LibraryPromise<MegaReaction[]>;
    addReaction(id: string, shortCode: string): LibraryPromise<any>;
    removeReaction(id: string, shortCode: string): LibraryPromise<any>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getContext(id: string): Promise<{
        data: any;
    }>;
    boost(id: string): LibraryPromise<MegaStatus>;
    removeBoost(id: string): LibraryPromise<MegaStatus>;
}
//# sourceMappingURL=statuses.d.ts.map