import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { CasingUtil } from '../../../utils/casing.js';
export class PleromaSearchRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async findUsers(query) {
        try {
            const data = await this.client.client.search(query.q || query.query, query);
            if (data.status !== 200) {
                return errorBuilder(ApiErrorCode.UNAUTHORIZED);
            }
            return { data: data.data.accounts };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async findPosts(query) {
        try {
            const data = await this.client.client.search(query.q || query.query, CasingUtil.snakeCaseKeys(query));
            if (data.status !== 200) {
                return errorBuilder(ApiErrorCode.UNAUTHORIZED);
            }
            return { data: data.data.statuses };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=search.js.map