import { CasingUtil } from '../../../utils/casing.js';
import { errorBuilder, notImplementedErrorBuilder, } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { MastodonNotificationsRouter } from '../mastodon/notifications.js';
export class PleromaNotificationsRouter extends MastodonNotificationsRouter {
    direct;
    pleromaClient;
    constructor(forwarded) {
        super(forwarded);
        this.direct = forwarded;
        this.pleromaClient = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get(query) {
        const data = await this.pleromaClient.client.getNotifications(CasingUtil.snakeCaseKeys(query));
        return {
            data: {
                data: data.data,
                maxId: undefined,
                minId: undefined,
            },
        };
    }
    async getChats() {
        try {
            const data = await this.pleromaClient.client.getConversationTimeline();
            return {
                data: data.data,
            };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async getChat() {
        return notImplementedErrorBuilder();
    }
    async getMessages() {
        return notImplementedErrorBuilder();
    }
    async getMentions(query) {
        let url = '/api/v1/notifications' +
            '?exclude_types[]=follow' +
            '&exclude_types[]=follow_request&exclude_types[]=favourite' +
            '&exclude_types[]=reblog&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async getSocialUpdates(query) {
        let url = '/api/v1/notifications' +
            '?exclude_types[]=follow_request' +
            '&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report&exclude_types[]=mention';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async getSubscriptionUpdates(query) {
        let url = '/api/v1/notifications' + '?types[]=status';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async sendMessage() {
        return notImplementedErrorBuilder();
    }
}
//# sourceMappingURL=notifications.js.map