import { NotificationGetQueryDto, NotificationsRoute } from '../_router/routes/notifications.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MegaConversation, MegaNotification } from '../../../types/megalodon.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { MastoGroupedNotificationsResults } from '../../../types/mastojs.types.js';
import { MastodonNotificationsRouter } from '../mastodon/notifications.js';
export declare class PleromaNotificationsRouter extends MastodonNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    pleromaClient: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    get(query: NotificationGetQueryDto): Promise<LibraryResponse<{
        data: MegaNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getChats(): LibraryPromise<MegaConversation[]>;
    getChat(): Promise<LibraryResponse<unknown>>;
    getMessages(): Promise<LibraryResponse<unknown>>;
    getMentions(query: NotificationGetQueryDto): Promise<LibraryResponse<{
        data: MastoGroupedNotificationsResults;
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<LibraryResponse<unknown>>;
    getSubscriptionUpdates(query: NotificationGetQueryDto): Promise<LibraryResponse<unknown>>;
    sendMessage(): Promise<LibraryResponse<unknown>>;
}
//# sourceMappingURL=notifications.d.ts.map