import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { CasingUtil } from '../../../utils/casing.js';
export class PleromaMediaRoute {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        const data = await this.client.client.uploadMedia(dto.file);
        return { data: data };
    }
    async updateDescription(id, text) {
        const data = await this.client.client.updateMedia(id, {
            description: text,
        });
        if (data.status !== 200) {
            console.log(data.statusText);
            return errorBuilder(data.statusText);
        }
        return { data: CasingUtil.camelCaseKeys(data.data) };
    }
}
//# sourceMappingURL=media.js.map