import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
export class PleromaListsRoute {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get(id) {
        const response = await this.client.client.getList(id);
        if (response.status !== 200)
            return errorBuilder(response.statusText);
        return { data: response.data };
    }
    async list() {
        const response = await this.client.client.getLists();
        if (response.status !== 200)
            return errorBuilder(response.statusText);
        return { data: response.data };
    }
    async update() {
        return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
    }
}
//# sourceMappingURL=lists.js.map