import { getSoftwareInfoShared } from '../_router/shared.js';
import { PleromaErrorHandler } from '../_router/_runner.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
export class PleromaInstanceRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    getLoginUrl(urlLike, {}) {
        throw new Error('Method not implemented.');
    }
    getTranslation(id, lang) {
        throw new Error('Method not implemented.');
    }
    getSoftwareInfo(urlLike) {
        return getSoftwareInfoShared(urlLike);
    }
    async getCustomEmojis(urlLike) {
        const x = MegalodonPleromaWrapper.create(urlLike).client;
        try {
            const { data, error } = await PleromaErrorHandler(x, x.getInstanceCustomEmojis);
            const dt = await data;
            if (error)
                return { error };
            return {
                data: dt.data.map((o) => ({
                    shortCode: o.shortcode,
                    url: o.url,
                    staticUrl: o.static_url,
                    visibleInPicker: o.visible_in_picker,
                    category: o.category,
                    aliases: [],
                    tags: [],
                })),
            };
        }
        catch (e) {
            if (e?.response?.data?.error?.code) {
                const code = e?.response?.data?.error?.code;
                return {
                    statusCode: e?.response?.status,
                    error: {
                        code,
                        message: code,
                    },
                };
            }
            else {
                return {
                    statusCode: e?.response?.status,
                    error: {
                        code: ApiErrorCode.UNKNOWN_ERROR,
                        message: e,
                    },
                };
            }
        }
    }
}
//# sourceMappingURL=instance.js.map