import { InstanceApi_CustomEmojiDTO, InstanceRoute } from '../_router/routes/instance.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
export declare class PleromaInstanceRouter implements InstanceRoute {
    direct: FetchWrapper;
    client: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    getLoginUrl(urlLike: string, {}: {
        appName: string;
        appCallback: string;
        uuid: string;
    }): LibraryPromise<{
        software: string;
        version?: string | null | undefined;
        loginUrl: string;
        loginStrategy: 'code' | 'miauth';
    }>;
    getTranslation(id: string, lang: string): Promise<LibraryResponse<any>>;
    getSoftwareInfo(urlLike: string): Promise<LibraryResponse<import("../_router/routes/instance.js").InstanceApi_SoftwareInfoDTO>>;
    getCustomEmojis(urlLike: string): Promise<LibraryResponse<InstanceApi_CustomEmojiDTO[]>>;
}
//# sourceMappingURL=instance.d.ts.map