import { AccountRoute, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO } from '../_router/routes/accounts.js';
import { BaseAccountsRouter } from '../default/accounts.js';
import { GetPostsQueryDTO } from '../_interface.js';
import { LibraryPromise, PaginatedLibraryPromise } from '../_router/routes/_types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import type { MastoAccount, MastoStatus } from '../../../types/mastojs.types.js';
import type { MegaAccount, MegaRelationship, MegaStatus } from '../../../types/megalodon.types.js';
import { MegalodonPleromaWrapper } from '../../../custom-clients/custom-clients.js';
import { ApiAsyncResult } from '../../../utils/api-result.js';
import { DriverWebfingerType } from '../../../types/query.types.js';
export declare class PleromaAccountsRouter extends BaseAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    get(id: string): LibraryPromise<MegaAccount>;
    lookup(webfinger: DriverWebfingerType): ApiAsyncResult<MegaAccount>;
    statuses(id: string, query: AccountRouteStatusQueryDto): ApiAsyncResult<any>;
    relationships(ids: string[]): LibraryPromise<MegaRelationship[]>;
    likes(query: GetPostsQueryDTO): PaginatedLibraryPromise<MegaStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): LibraryPromise<{
        data: MastoStatus[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    follow(id: string): LibraryPromise<MegaRelationship>;
    unfollow(id: string): LibraryPromise<MegaRelationship>;
    followers(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    followings(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    }>;
}
//# sourceMappingURL=accounts.d.ts.map