import { PleromaInstanceRouter } from './instance.js';
import { PleromaAccountsRouter } from './accounts.js';
import { PleromaStatusesRouter } from './statuses.js';
import { PleromaTrendsRouter } from './trends.js';
import { PleromaNotificationsRouter } from './notifications.js';
import { PleromaTimelinesRouter } from './timelines.js';
import { PleromaTagsRouter } from './tags.js';
import { PleromaSearchRouter } from './search.js';
import { PleromaMeRouter } from './me.js';
import { PleromaMediaRoute } from './media.js';
import { PleromaListsRoute } from './lists.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
class Adapter {
    driver;
    server;
    key;
    fetch;
    instances;
    accounts;
    statuses;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    post;
    user;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.fetch = FetchWrapper.create(dto.instance, dto.token);
        this.instances = new PleromaInstanceRouter(this.fetch);
        this.accounts = new PleromaAccountsRouter(this.fetch);
        this.statuses = new PleromaStatusesRouter(this.fetch);
        this.trends = new PleromaTrendsRouter(this.fetch);
        this.notifications = new PleromaNotificationsRouter(this.fetch);
        this.timelines = new PleromaTimelinesRouter(this.fetch);
        this.tags = new PleromaTagsRouter(this.fetch);
        this.search = new PleromaSearchRouter(this.fetch);
        this.me = new PleromaMeRouter(this.fetch);
        this.media = new PleromaMediaRoute(this.fetch);
        this.lists = new PleromaListsRoute(this.fetch);
        this.post = new PostMutatorRoute(this);
        this.user = new UserRoute(this);
    }
}
export { Adapter as PleromaApiAdapter };
//# sourceMappingURL=_router.js.map