import { ApiErrorCode } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MisskeyTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    publicAsGuest(urlLike, query) {
        throw new Error('Method not implemented.');
    }
    hashtagAsGuest(urlLike, q, query) {
        throw new Error('Method not implemented.');
    }
    async home(query) {
        try {
            return await this.client.client.request('notes/timeline', {
                ...query,
            });
        }
        catch (e) {
            if (e.code)
                throw new Error(ApiErrorCode.UNAUTHORIZED);
            throw new Error(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async public(query) {
        if (query?.local) {
            return await this.client.client.request('notes/local-timeline', {
                ...query,
                allowPartial: true,
                withBots: true,
                local: undefined,
            });
        }
        if (query?.social) {
            return await this.client.client.request('notes/hybrid-timeline', query);
        }
        else {
            return await this.client.client.request('notes/global-timeline', query);
        }
    }
    async bubble(query) {
        const { data, error } = await this.direct.post('/api/notes/bubble-timeline', query, {});
        if (error)
            throw new Error(ApiErrorCode.UNKNOWN_ERROR);
        return data;
    }
    async hashtag(q, query) {
        return await this.client.client.request('notes/search-by-tag', {
            tag: q,
            ...query,
        });
    }
    async list(q, query) {
        return await this.client.client.request('notes/user-list-timeline', { listId: q, ...query });
    }
}
//# sourceMappingURL=timelines.js.map