import { DhaagaJsTimelineQueryOptions, DriverTimelineGetApiResponse, TimelinesRoute } from '../_router/routes/timelines.js';
import { Endpoints } from 'misskey-js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export declare class MisskeyTimelinesRouter implements TimelinesRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    home(query: DhaagaJsTimelineQueryOptions): Promise<Endpoints['notes/timeline']['res']>;
    public(query: DhaagaJsTimelineQueryOptions & {
        withReplies?: boolean | null;
    }): Promise<Endpoints['notes/global-timeline']['res']>;
    bubble(query: DhaagaJsTimelineQueryOptions): Promise<any[]>;
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): Promise<Endpoints['notes/search-by-tag']['res']>;
    list(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
}
//# sourceMappingURL=timelines.d.ts.map