import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MisskeyTagsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async followedTags() {
        return { data: { data: [] } };
    }
    async follow(id) {
        return errorBuilder(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async unfollow(id) {
        return errorBuilder(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async get(id) {
        const data = await this.client.client.request('hashtags/show', { tag: id });
        return { data };
    }
    async getTrend(id) {
        const data = await this.client.client.request('hashtags/trend', {
            tag: id,
        });
        return { data };
    }
}
//# sourceMappingURL=tags.js.map