import { TagRoute } from '../_router/routes/tags.js';
import { PaginatedLibraryPromise, LibraryPromise } from '../_router/routes/_types.js';
import { Endpoints } from 'misskey-js';
import type { MastoTag } from '../../../types/mastojs.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export declare class MisskeyTagsRouter implements TagRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    followedTags(): PaginatedLibraryPromise<MastoTag[]>;
    follow(id: string): LibraryPromise<MastoTag>;
    unfollow(id: string): LibraryPromise<MastoTag>;
    get(id: string): LibraryPromise<Endpoints['hashtags/show']['res']>;
    getTrend(id: string): LibraryPromise<Endpoints['hashtags/trend']['res']>;
}
//# sourceMappingURL=tags.d.ts.map