import { DhaagaJsPostCreateDto, StatusesRoute } from '../_router/routes/statuses.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { Endpoints } from 'misskey-js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import type { MastoScheduledStatus } from '../../../types/mastojs.types.js';
import type { MissContext, MissNote } from '../../../types/misskey-js.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '../../../types/driver.types.js';
type RenoteCreateDTO = {
    localOnly: boolean;
    renoteId: string;
    visibility: 'followers';
};
export declare class MisskeyStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    create(dto: DhaagaJsPostCreateDto): LibraryPromise<MastoScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    get(id: string): Promise<LibraryResponse<MissNote>>;
    getReactions(postId: string): LibraryPromise<Endpoints['notes/reactions']['res']>;
    getReactionDetails(postId: string, reactionId: string): LibraryPromise<any>;
    addReaction(postId: string, reactionId: string): LibraryPromise<{
        success: true;
        reacted: true;
        id: string;
    }>;
    removeReaction(postId: string, reactionId: string): LibraryPromise<{
        success: false;
        reacted: false;
        id: string;
    }>;
    getState(id: string): LibraryPromise<Endpoints['notes/state']['res']>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    renotes(id: string): LibraryPromise<Endpoints['notes/renotes']['res']>;
    favourite(id: string): LibraryPromise<{
        success: boolean;
        isFavourited: true;
    }>;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    renote(dto: RenoteCreateDTO): LibraryPromise<{
        success: true;
        renoted: true;
        post: Endpoints['notes/create']['res'];
    }>;
    unrenote(id: string): LibraryPromise<{
        success: true;
        renoted: false;
    }>;
    getContext(id: string, limit?: number): LibraryPromise<MissContext>;
}
export {};
//# sourceMappingURL=statuses.d.ts.map