import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
import { notImplementedErrorBuilder } from '../_router/dto/api-responses.dto.js';
export class MisskeyNotificationsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get(query) {
        const data = await this.client.client.request('i/notifications-grouped', query);
        return { data: { data: data } };
    }
    async getUngrouped(query) {
        const data = await this.client.client.request('i/notifications', query);
        return { data: { data: data } };
    }
    async getMentions(query) {
        const data = await this.client.client.request('notes/mentions', {
            limit: 40,
            untilId: query.maxId || undefined,
        });
        return { data: { data: data } };
    }
    async getChats(driver) {
        const data = await this.client.client.request('notes/mentions', {
            limit: 40,
            visibility: 'specified',
        });
        return { data: { data: data } };
    }
    async getChat() {
        return notImplementedErrorBuilder();
    }
    async getMessages() {
        return notImplementedErrorBuilder();
    }
    async getSocialUpdates(query) {
        const data = await this.client.client.request('i/notifications-grouped', {
            limit: query.limit,
            untilId: query.maxId ?? undefined,
            includeTypes: [
                'follow',
                'followRequestAccepted',
                'receiveFollowRequest',
                'groupInvited',
                'reaction',
                'reaction:grouped',
                'renote',
                'renote:grouped',
            ],
            excludeTypes: ['note:grouped'],
        });
        return { data: { data: data } };
    }
    async getSubscriptions(query) {
        const data = await this.client.client.request('i/notifications-grouped', {
            limit: query.limit,
            untilId: query.maxId ?? undefined,
            includeTypes: ['note'],
        });
        return { data: { data: data } };
    }
    async sendMessage() {
        return notImplementedErrorBuilder();
    }
}
//# sourceMappingURL=notifications.js.map