import { NotificationGetQueryDto, NotificationsRoute } from '../_router/routes/notifications.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MastoNotification } from '../../../types/mastojs.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
import { KNOWN_SOFTWARE } from '../../../data/driver.js';
export declare class MisskeyNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    get(query: NotificationGetQueryDto): Promise<LibraryResponse<{
        data: MastoNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getUngrouped(query: NotificationGetQueryDto): LibraryPromise<{
        data: MastoNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    getMentions(query: NotificationGetQueryDto): Promise<{
        data: {
            data: any;
        };
    }>;
    getChats(driver: KNOWN_SOFTWARE): Promise<{
        data: {
            data: any;
        };
    }>;
    getChat(): Promise<LibraryResponse<unknown>>;
    getMessages(): Promise<LibraryResponse<unknown>>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<{
        data: {
            data: any;
        };
    }>;
    getSubscriptions(query: NotificationGetQueryDto): Promise<{
        data: {
            data: any;
        };
    }>;
    sendMessage(): Promise<LibraryResponse<unknown>>;
}
//# sourceMappingURL=notifications.d.ts.map