import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MisskeyMediaRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        const formData = new FormData();
        formData.append('file', dto.file);
        try {
            const data = await this.client.client.request('drive/files/create', formData);
            return { data };
        }
        catch (e) {
            console.log(e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async updateDescription(id, text) {
        try {
            const data = await this.client.client.request('drive/files/update', {
                fileId: id,
                comment: text,
            });
            return { data };
        }
        catch (e) {
            if (e.code) {
                return errorBuilder(e.code);
            }
            console.log(e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=media.js.map