import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MisskeyListsRoute {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get() {
        return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
    }
    async list() {
        const data = await this.client.client.request('users/lists/list', {});
        return { data };
    }
    async update() {
        return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
    }
    async listAntennas() {
        const data = await this.client.client.request('antennas/list', {});
        return { data };
    }
}
//# sourceMappingURL=lists.js.map