import { InstanceApi_CustomEmojiDTO, InstanceRoute } from '../_router/routes/instance.js';
import type { mastodon } from 'masto';
import { LibraryPromise } from '../_router/routes/_types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export declare class MisskeyInstanceRouter implements InstanceRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    getLoginUrl(urlLike: string, {}: {
        appName: string;
        appCallback: string;
        uuid: string;
    }): LibraryPromise<{
        software: string;
        version?: string | null | undefined;
        loginUrl: string;
        loginStrategy: 'code' | 'miauth';
    }>;
    getCustomEmojis(urlLike: string): Promise<LibraryResponse<InstanceApi_CustomEmojiDTO[]>>;
    getSoftwareInfo(urlLike: string): Promise<LibraryResponse<import("../_router/routes/instance.js").InstanceApi_SoftwareInfoDTO>>;
    getTranslation(id: string, lang: string): Promise<LibraryResponse<mastodon.v1.Translation>>;
}
//# sourceMappingURL=instance.d.ts.map