import { AccountRoute, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO } from '../_router/routes/accounts.js';
import { Endpoints } from 'misskey-js';
import { BaseAccountsRouter } from '../default/accounts.js';
import { FollowPostDto, GetPostsQueryDTO } from '../_interface.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import type { MastoAccount, MastoRelationship } from '../../../types/mastojs.types.js';
import { MissUserDetailed } from '../../../types/misskey-js.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { MisskeyJsWrapper } from '../../../custom-clients/custom-clients.js';
export declare class MisskeyAccountsRouter extends BaseAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    statuses(id: string, query: AccountRouteStatusQueryDto): Promise<import("../../../utils/result.js").Result<any, string>>;
    relationships(ids: string[]): LibraryPromise<MastoRelationship[]>;
    get(id: string): LibraryPromise<MissUserDetailed>;
    getMany(ids: string[]): LibraryPromise<MissUserDetailed[]>;
    follow(id: string, opts: FollowPostDto): LibraryPromise<Endpoints['following/create']['res']>;
    unfollow(id: string): LibraryPromise<Endpoints['following/delete']['res']>;
    block(id: string): LibraryPromise<Endpoints['blocking/create']['res']>;
    unblock(id: string): LibraryPromise<Endpoints['blocking/delete']['res']>;
    findByWebfinger({ username, host }: {
        username: string;
        host: string | null;
    }): Promise<{
        data: any;
    } | ({
        error: import("../../../types/result.types.js").ApiErrorComponent;
        data?: undefined;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    }) | ({
        error?: undefined;
        data: unknown;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    })>;
    findByUserId(id: string): Promise<{
        data: any;
    } | ({
        error: import("../../../types/result.types.js").ApiErrorComponent;
        data?: undefined;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    }) | ({
        error?: undefined;
        data: unknown;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    })>;
    findByUserIds(ids: string[]): Promise<{
        data: any;
    } | ({
        error: import("../../../types/result.types.js").ApiErrorComponent;
        data?: undefined;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    }) | ({
        error?: undefined;
        data: unknown;
    } & {
        statusCode?: number | undefined;
        raw?: any;
    })>;
    renoteMute(id: string): LibraryPromise<{
        renoteMuted: true;
    }>;
    renoteUnmute(id: string): LibraryPromise<{
        renoteMuted: false;
    }>;
    likes(query: GetPostsQueryDTO): Promise<any>;
    bookmarks(query: BookmarkGetQueryDTO): Promise<LibraryResponse<{
        data: Endpoints['i/favorites']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    followers(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    } | {
        data: Endpoints['users/followers']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>;
    followings(query: FollowerGetQueryDTO): LibraryPromise<{
        data: Endpoints['users/following']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>;
}
//# sourceMappingURL=accounts.d.ts.map