import { MisskeyInstanceRouter } from './instance.js';
import { MisskeyAccountsRouter } from './accounts.js';
import { MisskeyStatusesRouter } from './statuses.js';
import { MisskeyTrendsRouter } from './trends.js';
import { MisskeyNotificationsRouter } from './notifications.js';
import { MisskeyTimelinesRouter } from './timelines.js';
import { MisskeyTagsRouter } from './tags.js';
import { MisskeySearchRouter } from './search.js';
import { MisskeyMeRouter } from './me.js';
import { MisskeyMediaRouter } from './media.js';
import { MisskeyListsRoute } from './lists.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
class Adapter {
    driver;
    server;
    key;
    fetch;
    instances;
    accounts;
    statuses;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    post;
    user;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.fetch = FetchWrapper.create(dto.instance, dto.token);
        this.instances = new MisskeyInstanceRouter(this.fetch);
        this.accounts = new MisskeyAccountsRouter(this.fetch);
        this.statuses = new MisskeyStatusesRouter(this.fetch);
        this.trends = new MisskeyTrendsRouter(this.fetch);
        this.notifications = new MisskeyNotificationsRouter(this.fetch);
        this.timelines = new MisskeyTimelinesRouter(this.fetch);
        this.tags = new MisskeyTagsRouter(this.fetch);
        this.search = new MisskeySearchRouter(this.fetch);
        this.me = new MisskeyMeRouter(this.fetch);
        this.media = new MisskeyMediaRouter(this.fetch);
        this.lists = new MisskeyListsRoute(this.fetch);
        this.post = new PostMutatorRoute(this);
        this.user = new UserRoute(this);
    }
}
export { Adapter as MisskeyApiAdapter };
//# sourceMappingURL=_router.js.map