import { RestClientCreateDTO } from '../_interface.js';
import { MisskeyInstanceRouter } from './instance.js';
import { MisskeyAccountsRouter } from './accounts.js';
import { MisskeyStatusesRouter } from './statuses.js';
import { MisskeyTrendsRouter } from './trends.js';
import { MisskeyNotificationsRouter } from './notifications.js';
import { MisskeyTimelinesRouter } from './timelines.js';
import { MisskeyTagsRouter } from './tags.js';
import { MisskeySearchRouter } from './search.js';
import { MisskeyMeRouter } from './me.js';
import { MisskeyMediaRouter } from './media.js';
import { MisskeyListsRoute } from './lists.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { ApiTargetInterface } from '../_router/routes/_index.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
import { KNOWN_SOFTWARE } from '../../../data/driver.js';
declare class Adapter implements ApiTargetInterface {
    driver: KNOWN_SOFTWARE | string;
    server: string | null;
    key: string;
    fetch: FetchWrapper;
    instances: MisskeyInstanceRouter;
    accounts: MisskeyAccountsRouter;
    statuses: MisskeyStatusesRouter;
    trends: MisskeyTrendsRouter;
    notifications: MisskeyNotificationsRouter;
    timelines: MisskeyTimelinesRouter;
    tags: MisskeyTagsRouter;
    search: MisskeySearchRouter;
    me: MisskeyMeRouter;
    media: MisskeyMediaRouter;
    lists: MisskeyListsRoute;
    post: PostMutatorRoute;
    user: UserRoute;
    constructor(driver: KNOWN_SOFTWARE | string, server: string | null, dto: RestClientCreateDTO);
}
export { Adapter as MisskeyApiAdapter };
//# sourceMappingURL=_router.d.ts.map