import { MastoErrorHandler } from '../_router/_runner.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonTrendsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async tags() {
        const fn = this.client.lib.v1.trends.tags.list;
        const { data, error } = await MastoErrorHandler(fn);
        if (error)
            return { error };
        const res = await data;
        return { data: res };
    }
    async posts(opts) {
        const fn = this.client.lib.v1.trends.statuses.list;
        const { data, error } = await MastoErrorHandler(fn, [opts]);
        if (error)
            return { error };
        const res = await data;
        return { data: res };
    }
    async links() {
        const fn = this.client.lib.v1.trends.links.list;
        const { data, error } = await MastoErrorHandler(fn);
        if (error)
            return { error };
        const res = await data;
        return { data: res };
    }
}
//# sourceMappingURL=trends.js.map