import { MastoErrorHandler } from '../_router/_runner.js';
import { createRestAPIClient } from 'masto';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    anonLibClient(urlLike) {
        return createRestAPIClient({ url: urlLike });
    }
    async home(query) {
        const fn = this.client.lib.v1.timelines.home.list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
    async public(query) {
        const fn = this.client.lib.v1.timelines.public.list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
    async publicAsGuest(urlLike, query) {
        const anonLib = this.anonLibClient(urlLike);
        const fn = anonLib.v1.timelines.public.list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
    async hashtag(q, query) {
        const fn = this.client.lib.v1.timelines.tag.$select(q).list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
    async hashtagAsGuest(urlLike, q, query) {
        const anonLib = this.anonLibClient(urlLike);
        const fn = anonLib.v1.timelines.tag.$select(q).list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
    async list(q, query) {
        const fn = this.client.lib.v1.timelines.list.$select(q).list;
        const { data, error } = await MastoErrorHandler(fn, [query]);
        if (error || !data)
            throw new Error(error?.code);
        return data;
    }
}
//# sourceMappingURL=timelines.js.map