import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonTagRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async followedTags(query) {
        const { data, error } = await this.direct.getCamelCaseWithLinkPagination('/api/v1/followed_tags', query);
        if (error || !data) {
            return errorBuilder();
        }
        return { data };
    }
    async follow(id) {
        const data = await this.client.lib.v1.tags.$select(id).follow();
        return { data };
    }
    async get(id) {
        const data = await this.client.lib.v1.tags.$select(id).fetch();
        return { data };
    }
    async unfollow(id) {
        const data = await this.client.lib.v1.tags.$select(id).unfollow();
        return { data };
    }
}
//# sourceMappingURL=tags.js.map