import { MastoErrorHandler } from '../_router/_runner.js';
import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
import { Err, Ok } from '../../../utils/index.js';
export class MastodonStatusesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        const fn = this.client.lib.v1.statuses.create;
        const { data, error } = await MastoErrorHandler(fn, [
            {
                ...dto,
                visibility: dto.mastoVisibility,
            },
        ]);
        if (error || !data)
            return errorBuilder(error);
        const retData = await data;
        return { data: retData };
    }
    async delete(id) {
        const fn = this.client.lib.v1.statuses.$select(id).remove;
        const { data, error } = await MastoErrorHandler(fn);
        if (error || !data)
            return { success: false, deleted: false };
        return { success: true, deleted: true };
    }
    async get(id) {
        const fn = this.client.lib.v1.statuses.$select(id).fetch;
        const { data, error } = await MastoErrorHandler(fn);
        if (error || !data)
            return errorBuilder(error);
        const retData = await data;
        return { data: retData };
    }
    async bookmark(id) {
        try {
            const data = await this.client.lib.v1.statuses.$select(id).bookmark();
            return Ok({ state: !!data.bookmarked });
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async unBookmark(id) {
        try {
            const data = await this.client.lib.v1.statuses.$select(id).unbookmark();
            return Ok({ state: !!data.bookmarked });
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async like(id) {
        try {
            const data = await this.client.lib.v1.statuses.$select(id).favourite();
            return Ok({ state: !!data.favourited, counter: data.favouritesCount });
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async removeLike(id) {
        try {
            const data = await this.client.lib.v1.statuses.$select(id).unfavourite();
            return Ok({ state: !!data.favourited, counter: data.favouritesCount });
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async getContext(id) {
        try {
            const ctx = await this.client.lib.v1.statuses.$select(id).context.fetch();
            return { data: ctx };
        }
        catch (e) {
            console.log(e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async boost(id) {
        const data = await this.client.lib.v1.statuses
            .$select(id)
            .reblog({ visibility: 'public' });
        return { data };
    }
    async removeBoost(id) {
        const data = await this.client.lib.v1.statuses.$select(id).unreblog();
        return { data };
    }
}
//# sourceMappingURL=statuses.js.map