import { DhaagaJsPostCreateDto, StatusesRoute } from '../_router/routes/statuses.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import type { MastoContext, MastoScheduledStatus, MastoStatus } from '../../../types/mastojs.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '../../../types/driver.types.js';
export declare class MastodonStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    create(dto: DhaagaJsPostCreateDto): LibraryPromise<MastoScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    get(id: string): LibraryPromise<MastoStatus>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getContext(id: string): LibraryPromise<MastoContext>;
    boost(id: string): LibraryPromise<MastoStatus>;
    removeBoost(id: string): LibraryPromise<MastoStatus>;
}
//# sourceMappingURL=statuses.d.ts.map