import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonSearchRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async findUsers(query) {
        try {
            const data = await this.client.lib.v2.search.list({
                ...query,
                q: query.query,
            });
            return { data: data.accounts };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async findPosts(query) {
        try {
            const data = await this.client.lib.v2.search.list({
                ...query,
                q: query.query,
            });
            return { data: data.statuses };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async unifiedSearch(query) {
        try {
            const data = await this.client.lib.v2.search.list({
                ...query,
            });
            return { data: data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=search.js.map