import { errorBuilder, notImplementedErrorBuilder, } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonNotificationsRouter {
    direct;
    mastoClient;
    constructor(forwarded) {
        this.direct = forwarded;
        this.mastoClient = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async get(query) {
        const { excludeTypes, types, ...rest } = query;
        if (types && types.length > 0) {
            rest['types[]'] = types.join(';');
        }
        const { data: _data, error } = await this.direct.getCamelCaseWithLinkPagination('/api/v1/notifications', rest);
        if (error || !_data) {
            return notImplementedErrorBuilder();
        }
        return { data: _data };
    }
    async getMentions(query) {
        let url = '/api/v2/notifications' +
            '?exclude_types[]=follow' +
            '&exclude_types[]=follow_request&exclude_types[]=favourite' +
            '&exclude_types[]=reblog&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async getSocialUpdates(query) {
        let url = '/api/v2/notifications' +
            '?grouped_types[]=reblog' +
            '&grouped_types[]=follow&exclude_types[]=follow_request' +
            '&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report&exclude_types[]=mention';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async getSubscriptionUpdates(query) {
        let url = '/api/v2/notifications' + '?types[]=status';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        if (result.error)
            return errorBuilder();
        return { data: result.data };
    }
    async getChats() {
        try {
            const data = await this.mastoClient.lib.v1.conversations.list();
            return { data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async getChat() {
        return notImplementedErrorBuilder();
    }
    async getMessages() {
        return notImplementedErrorBuilder();
    }
    async markChatRead(id) {
        try {
            const data = await this.mastoClient.lib.v1.conversations
                .$select(id)
                .read();
            return { data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async markChatUnread(id) {
        try {
            const data = await this.mastoClient.lib.v1.conversations
                .$select(id)
                .unread();
            return { data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async markChatRemove(id) {
        try {
            const data = await this.mastoClient.lib.v1.conversations
                .$select(id)
                .remove();
            return { data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async sendMessage() {
        return notImplementedErrorBuilder();
    }
}
//# sourceMappingURL=notifications.js.map