import { NotificationGetQueryDto, NotificationsRoute } from '../_router/routes/notifications.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MastoConversation, MastoGroupedNotificationsResults, MastoNotification } from '../../../types/mastojs.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
import { MegaConversation, MegaNotification } from '../../../types/megalodon.types.js';
export declare class MastodonNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    mastoClient: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    get(query: NotificationGetQueryDto): Promise<LibraryResponse<{
        data: MastoNotification[] | MegaNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getMentions(query: NotificationGetQueryDto): Promise<LibraryResponse<{
        data: MastoGroupedNotificationsResults;
        minId?: string | null;
        maxId?: string | null;
    }>>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<LibraryResponse<unknown>>;
    getSubscriptionUpdates(query: NotificationGetQueryDto): Promise<LibraryResponse<unknown>>;
    getChats(): LibraryPromise<MastoConversation[] | MegaConversation[]>;
    getChat(): Promise<LibraryResponse<unknown>>;
    getMessages(): Promise<LibraryResponse<unknown>>;
    markChatRead(id: string): LibraryPromise<MastoConversation>;
    markChatUnread(id: string): LibraryPromise<MastoConversation>;
    markChatRemove(id: string): LibraryPromise<void>;
    sendMessage(): Promise<LibraryResponse<unknown>>;
}
//# sourceMappingURL=notifications.d.ts.map