import { getSoftwareInfoShared } from '../_router/shared.js';
import { MastoErrorHandler } from '../_router/_runner.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
export class MastodonInstanceRouter {
    direct;
    constructor(forwarded) {
        this.direct = forwarded;
    }
    getLoginUrl(urlLike, {}) {
        throw new Error('Method not implemented.');
    }
    async getCustomEmojis(urlLike) {
        const fn = MastoJsWrapper.create(urlLike).lib.v1.customEmojis.list;
        const { data, error } = await MastoErrorHandler(fn);
        if (error)
            return { error };
        const x = await data;
        if (!x)
            return { error: { code: ApiErrorCode.UNKNOWN_ERROR } };
        return {
            data: x.map((o) => ({
                shortCode: o.shortcode,
                url: o.url,
                staticUrl: o.staticUrl,
                visibleInPicker: o.visibleInPicker,
                category: o.category,
                aliases: [],
                tags: [],
            })),
            error,
        };
    }
    async getSoftwareInfo(urlLike) {
        return getSoftwareInfoShared(urlLike);
    }
    async getTranslation(id, lang) {
        const _client = MastoJsWrapper.create(this.direct.baseUrl, this.direct.token);
        const data = await _client.lib.v1.statuses
            .$select(id)
            .translate({ lang: 'en' });
        return {
            data,
        };
    }
}
//# sourceMappingURL=instance.js.map