import { InstanceApi_CustomEmojiDTO, InstanceRoute, MastoTranslation } from '../_router/routes/instance.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
export declare class MastodonInstanceRouter implements InstanceRoute {
    direct: FetchWrapper;
    constructor(forwarded: FetchWrapper);
    getLoginUrl(urlLike: string, {}: {
        appName: string;
        appCallback: string;
        uuid: string;
    }): LibraryPromise<{
        software: string;
        version?: string | null | undefined;
        loginUrl: string;
        loginStrategy: 'code' | 'miauth';
    }>;
    getCustomEmojis(urlLike: string): Promise<LibraryResponse<InstanceApi_CustomEmojiDTO[]>>;
    getSoftwareInfo(urlLike: string): Promise<LibraryResponse<import("../_router/routes/instance.js").InstanceApi_SoftwareInfoDTO>>;
    getTranslation(id: string, lang: string): Promise<LibraryResponse<MastoTranslation>>;
}
//# sourceMappingURL=instance.d.ts.map